/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "baselistviewitem.h"
#include "../utils/debugger.h"

#include <iostream.h>

 	// build general constructors, based on QListViewItem 	
	BaseListViewItem::BaseListViewItem(QListView *pqoListView)
		: QListViewItem(pqoListView)
	{
		initObject();
	} // end constructor
	
	BaseListViewItem::BaseListViewItem(QListView *pqoListView, QListViewItem *pqoAfterItem)
		: QListViewItem(pqoListView, pqoAfterItem)
	{
		initObject();
	} // end constructor
	
	BaseListViewItem::BaseListViewItem(QListViewItem *pqoListViewItem)
		: QListViewItem(pqoListViewItem)
	{
		initObject();
	} // end constructor
		
	BaseListViewItem::BaseListViewItem(QListViewItem *pqoListViewItem, QListViewItem *pqoAfterItem)
		: QListViewItem(pqoListViewItem, pqoAfterItem)
	{
		initObject();
	} // end constructor

	/**
	 * Destructor
	 */
	BaseListViewItem::~BaseListViewItem()
	{
		//string strMethodName = "BaseListViewItem::~BaseListViewItem";
		//Debugger::entered(strMethodName);
		// lets kill all children objects of this list view item
		// by destroying the popup this should destroy its children as well
		if (m_pqoPopupMenu != 0)
		{
			delete m_pqoPopupMenu;
			m_pqoPopupMenu = 0;
		} // end if popup exists
		//Debugger::exited(strMethodName);
	} // end destructor
	
	/**
	 * Used to update the description for this live view item.
	 */
	void BaseListViewItem::updateDescription()
	{
		// default: do nothing
	} // end updateDescription
	
	const QString & BaseListViewItem::getDescription()
	{
		return m_qstrDescription;
	} // end isLeaf

	void BaseListViewItem::setDescription(const QString & rqstrDescription)
	{
		m_qstrDescription = rqstrDescription;
	} // end isLeaf

	/**
 	 * Used to set the expanded flag.
 	 * @param boolean to indicate if this list view item has been expanded before
   */			    							
	void BaseListViewItem::setExpanded(bool bExpanded)
	{
		m_bExpanded = bExpanded;
	} // end setExpanded
				
	bool BaseListViewItem::hasExpanded()
	{
		return m_bExpanded;
	} // end hasExpanded
		
	bool BaseListViewItem::isLeaf()
	{
		return m_bLeaf;
	} // end isLeaf
	
	void BaseListViewItem::setLeaf(bool bLeaf)
	{
		m_bLeaf = bLeaf;
	} // end setLeaf

	/**
 	 * Used to delete all the children of this item.
   */			    						
	void BaseListViewItem::deleteChildren()
	{
		// lets loop through the children of this list view item and delete
		QListViewItem *poNextItem = firstChild();
		QListViewItem *poCurrentItem = 0;
		while (poNextItem != 0)
		{
			poCurrentItem = poNextItem;
			poNextItem = poCurrentItem->nextSibling();
			// delete the item
			delete poCurrentItem;
		} // end while more items
	} // end deleteChildren
		
	/**
 	 * Used to traverse all children and warn them to prepare their own children.
   */			    						
	void BaseListViewItem::initGrandChildren()
	{	
	
		string strMethodName = "BaseListViewItem::initGrandChildren";	
		
		Debugger::entered(strMethodName);

		if (m_bExpanded == false)		
		{
  		// get first child
  		BaseListViewItem *poCurrentChild = (BaseListViewItem*) firstChild();
  		// check to see if any children exist
  		if (poCurrentChild == 0)
  		{
  			return;	// lets get out now
  		} // end if not children exist
  		
  		poCurrentChild->initChildren();
  		
  		// get next child
  		poCurrentChild = (BaseListViewItem*) poCurrentChild->nextSibling();		
  		while (poCurrentChild != 0)
  		{
  			poCurrentChild->initChildren();			
  			// get next child
  			poCurrentChild = (BaseListViewItem*) poCurrentChild->nextSibling();					
  		} // end while more children
  		
  		// set as expanded
  		m_bExpanded = true;
  	} // end if not expanded before
	
  	Debugger::exited(strMethodName);
	} // end initGrandChildren

	/**
 	 * Used to refresh itself and its children.
   */			    			
	void BaseListViewItem::refreshList()
	{
		// check to see if already open
		bool bWasOpen = isOpen();
		deleteChildren();
		m_bExpanded = false;				
		// lets see if it was previously open or not (make what it was before)
		if (bWasOpen == true)
		{
			initChildren();
			initGrandChildren();
			setOpen(true);		// lets keep it how it was
		} // end if was open previously
		else
		{
			initChildren();
			setOpen(false);		// lets keep it how it was
		} // end else if was not open previously
		
	} // end refreshList

	/**
 	 * Displays the right pressed menu for this item.
   */			    	
	void BaseListViewItem::showRightPressedMenu(const QPoint & rqoLocation, int nColumn)
	{
		// default: do nothing
	} // end showRightPressedMenu
	
	/**
 	 * Used to create all the first level children of the current item.
   */			    						
	void BaseListViewItem::initChildren()
	{
		// default: do nothing
	} // end initChildren
			
	void BaseListViewItem::initObject()
	{
		m_qstrDescription = ""; // empty qstring
		m_bLeaf = false;
		m_bExpanded = false;		
		m_pqoPopupMenu = 0;
	} // end initObject
