/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "dbtrigger.h"

	/**
	 * The types of triggers.
	 */
	const int DBTrigger::AFTER_INSERT = 5;
	const int DBTrigger::BEFORE_INSERT = 7;	
	const int DBTrigger::AFTER_DELETE = 9;	
	const int DBTrigger::BEFORE_DELETE = 11;	
	const int DBTrigger::AFTER_UPDATE = 17;
	const int DBTrigger::BEFORE_UPDATE = 19;
				
	/**
 	 * Constructor
   */		
	DBTrigger::DBTrigger()
	{
		clear();	
	} // end constructor
	
	/**
 	 * Destructor
   */		
	DBTrigger::~DBTrigger()
	{
	} // end destructor

	/**
	 * This function will clear out variables in this object, so that it can be used again.
	 */
	void DBTrigger::clear()
	{
		m_strTriggerName = "";
		m_strTableName = "";
		m_strTriggerComment = "";
		m_strProcedureName = "";
		m_nTriggerType = 0;
		m_bConstraint = false;
		m_vstrTriggerArguments.clear();
	} // end clear
			
	/**
 	 * Used to set the trigger name.
   */			    	
	void DBTrigger::setTriggerName(const string &rstrTriggerName)
	{
		m_strTriggerName = rstrTriggerName;
	} // end setTriggerName

	/**
 	 * Used to retrieve the trigger name.
   */			    			
	const string & DBTrigger::getTriggerName() const
	{
		return m_strTriggerName;
	} // end getTriggerName

	/**
 	 * Used to set the table name.
   */			    						
	void DBTrigger::setTableName(const string &rstrTableName)
	{
		m_strTableName = rstrTableName;
	} // end setTableName

	/**
 	 * Used to retrieve the table name.
   */			    			
	const string & DBTrigger::getTableName() const
	{
		return m_strTableName;
	} // end getTableName			

	/**
 	 * Used to set the Procedure name.
   */			    						
	void DBTrigger::setProcedureName(const string &rstrProcedureName)
	{
		m_strProcedureName = rstrProcedureName;
	} // end setProcedureName

	/**
 	 * Used to retrieve the Procedure name.
   */			    			
	const string & DBTrigger::getProcedureName() const
	{
		return m_strProcedureName;
	} // end getProcedureName			

	/**
 	 * Used to add a trigger argument. These are used by the constraint triggers.
   */			    						
	void DBTrigger::addTriggerArgument(const string &rstrTriggerArgument)
	{
		m_vstrTriggerArguments.push_back(rstrTriggerArgument);
	} // end setTriggerArguments

	/**
 	 * Used to retrieve a trigger argument. These are used by the constraint triggers.
   */			    			
	const string & DBTrigger::getTriggerArgument(int nArgIndex) const throw (IndexOutOfRangeException)			
	{
		if (nArgIndex < 0 || nArgIndex >= getNumberOfArguments())
		{
			throw IndexOutOfRangeException("Index out of range.", "DBTrigger", "getTriggerArgument");					
		} // end if out of range
		return m_vstrTriggerArguments[nArgIndex];
	} // end getTriggerArguments			

	/**
	 * Used to get the number of trigger arguments for this trigger.
	 */
	int DBTrigger::getNumberOfArguments() const
	{
		return m_vstrTriggerArguments.size();
	} // end getNumberOfArguments 			
		
	/**
 	 * Used to set the constraint property.
   */			    						
	void DBTrigger::setConstraint(bool bConstraint)
	{
		m_bConstraint = bConstraint;
	} // end setConstraint

	/**
 	 * Used to get the constraint property.
   */			    						
	bool DBTrigger::isConstraint() const
	{
		return m_bConstraint;
	} // end isConstraint	
	
	/**
 	 * Used to set the trigger type.
   */			    						
	void DBTrigger::setTriggerType(int nTriggerType)
	{
		m_nTriggerType = nTriggerType;
	} // end setTriggerType

	/**
 	 * Used to get the trigger type.
   */			    						
	int DBTrigger::getTriggerType() const
	{
		return m_nTriggerType;
	} // end getTriggerType
	
	/**
 	 * Used to retrieve a trigger comment.
   */			    			
	const string & DBTrigger::getTriggerComment() const
	{
		return m_strTriggerComment;
	} // end getTriggerComment			

	/**
 	 * Used to set a trigger comment.
   */			    			
	void DBTrigger::setTriggerComment(const string &rstrComment)
	{
		m_strTriggerComment = rstrComment;
	} // end setTriggerComment			

